import iesve
from results import max_loads
from ies_file_picker import IesFilePicker

project = iesve.VEProject.get_current_project()
model = project.models[0]
bodies = model.get_bodies(False)
s = iesve.ApacheSim()

s.run_simulation()

file_name = IesFilePicker.pick_aps_file()
f = iesve.ResultsReader()
f.open_aps_data(file_name)

max_BL = max_loads(f)
print(max_BL)

while max_BL > 3000:
    for body in bodies:
        
        room_data = body.get_room_data()
        conditions = room_data.get_room_conditions()

        htg_set = conditions['heating_setpoint']

        htg_set -= 1

        room_conditions_data = { 'heating_setpoint_from_template': False, 'heating_setpoint': htg_set}
        general_data = {}
        system_data = {}
        room_data.set(general_data, room_conditions_data, system_data)
    s.run_simulation()
    f = iesve.ResultsReader()
    f.open_aps_data(file_name)
    max_BL = max_loads(f)
    print(max_BL) 
